package com.biz.crm.sfa.business.template.store.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.store.inspect.sdk.dto.StoreInspectDto;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import com.biz.crm.sfa.business.template.store.local.service.StoreInspectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@Api(tags = "店铺检查：StoreInspect:店铺检查")
@RequestMapping("/v1/storeInspect/storeInspect")
public class StoreInspectController {

  @Autowired
  private StoreInspectService storeInspectService;

  /**
   * 创建工店铺检查
   *
   * @param entity 店铺检查
   * @return 创建结果
   */
  @ApiOperation("创建店铺检查")
  @PostMapping("")
  public Result<StoreInspectEntity> create(@RequestBody StoreInspectEntity entity) {
    return Result.ok(this.storeInspectService.create(entity));
  }

  /**
   * 更新工店铺检查
   *
   * @param entity 店铺检查
   * @return 更新结果
   */
  @ApiOperation("更新店铺检查")
  @PatchMapping("")
  public Result<StoreInspectEntity> update(@RequestBody StoreInspectEntity entity) {
    return Result.ok(this.storeInspectService.update(entity));
  }

  /**
   * 分页查询店铺检查列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 店铺检查列表
   */
  @ApiModelProperty("分页查询店铺检查列表")
  @GetMapping("findByConditions")
  public Result<Page<StoreInspectEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "storeInspectDto", value = "分页Dto") StoreInspectDto dto) {
    return Result.ok(this.storeInspectService.findByConditions(pageable, dto));
  }

  /**
   * 根据id查询店铺检查详情
   * @param id id
   * @return 店铺检查详情
   */
  @ApiModelProperty("查询店铺检查详情")
  @GetMapping("findDetailById")
  public Result<StoreInspectEntity> findDetailById(@RequestParam("id")String id) {
    return Result.ok(this.storeInspectService.findDetailById(id));
  }
}
