package com.biz.crm.sfa.business.template.store.local.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleInventoryWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleUploadWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 库存盘点实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInspectFileModel", description = "店铺检查文件类")
public class StoreInspectFileModel extends UuidEntity {

  /**
   * 店铺检查id
   */
  @DynamicField(fieldName = "店铺检查id", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class, required = false)
  @ApiModelProperty("店铺检查id")
  private String storeInspectId;

  /**
   * 访问路径
   */
  @DynamicField(fieldName = "访问路径", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleUploadWidget.class)
  @ApiModelProperty(value = "访问路径")
  private String url;
}
