package com.biz.crm.sfa.business.template.store.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectFileEntity;
import com.biz.crm.sfa.business.template.store.local.mapper.StoreInspectFileMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 店铺检查文件数据操作repository
 *
 * @author jerry7
 */
@Component
public class StoreInspectFileRepository extends ServiceImpl<StoreInspectFileMapper, StoreInspectFileEntity> {

  /**
   * 根据库存盘点id删除库存盘点详情
   *
   * @param checkId 库存盘点id
   */
  public void deleteByCheckId(String checkId) {
    this.lambdaUpdate().eq(StoreInspectFileEntity::getStoreInspectId, checkId).remove();
  }

  /**
   * 根据库存盘点id查询库存盘点详情列表
   * @param checkId 库存盘点id
   * @return 库存详情列表
   */
  public List<StoreInspectFileEntity> findByCheckIdAndInspectType(String checkId,String inspectType) {
    return this.lambdaQuery().eq(StoreInspectFileEntity::getStoreInspectId, checkId)
            .eq(StoreInspectFileEntity::getInspectType,inspectType)
            .list();
  }
}
