package com.biz.crm.sfa.business.template.store.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.store.inspect.sdk.dto.StoreInspectDto;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import com.biz.crm.sfa.business.template.store.local.mapper.StoreInspectMapper;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 店面检查数据操作repository
 *
 * @author jerry7
 */
@Component
public class StoreInspectRepository extends ServiceImpl<StoreInspectMapper, StoreInspectEntity> {


  /**
   * 根据上级id和表单key查询店面检查实体
   * @param parentCode 上级id
   * @param dynamicKey 表单key
   * @return 店面检查实体
   */
  public StoreInspectEntity findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.lambdaQuery().eq(StoreInspectEntity::getParentCode, parentCode)
            .eq(StoreInspectEntity::getDynamicKey, dynamicKey)
            .one();
  }

  /**
   * 分页查询店面检查列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 店面检查列表
   */
  public Page<StoreInspectEntity> findByConditions(Pageable pageable, StoreInspectDto dto){
    Page<StoreInspectEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
