package com.biz.crm.sfa.business.template.store.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import com.biz.crm.sfa.business.template.store.local.model.StoreInspectModel;
import com.biz.crm.sfa.business.template.store.local.service.StoreInspectModelService;
import com.biz.crm.sfa.business.template.store.local.service.StoreInspectService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

@Component
public class DynamicFormOperationStrategyForStoreInspect implements DynamicFormOperationStrategy<StoreInspectModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;

  @Autowired
  private StoreInspectService storeInspectService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private StoreInspectModelService storeInspectModelService;

  @Override
  public void onDynamicFormCreate(StoreInspectModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    StoreInspectEntity StoreInspectEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, StoreInspectEntity.class, HashSet.class, ArrayList.class, "shelvesDisplayPictures","materialDisplayPictures","priceTagPictures");
    this.storeInspectService.create(StoreInspectEntity);
  }

  @Override
  public void onDynamicFormModify(StoreInspectModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    StoreInspectEntity StoreInspectEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, StoreInspectEntity.class, HashSet.class, ArrayList.class, "shelvesDisplayPictures","materialDisplayPictures","priceTagPictures");
    this.storeInspectService.update(StoreInspectEntity);
  }

  @Override
  public StoreInspectModel findByParentCode(String dynamicKey, String parentCode) {
    if (StringUtils.isAnyBlank(dynamicKey, parentCode)) {
      return null;
    }
    return this.storeInspectModelService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "店铺检查";
  }

  @Override
  public Class<StoreInspectModel> dynamicFormClass() {
    return StoreInspectModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {

  }

  @Override
  public int getOrder() {
    return 11;
  }
}
