package com.biz.crm.sfa.business.template.store.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.biz.crm.sfa.business.template.store.local.model.StoreInspectModel;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 店铺检查表单模板操作策略实现类
 *
 * @author jerry7
 */
@Component
public class DynamicTemplateOperationStrategyForStoreInspect implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyForStoreInspect dynamicFormOperationStrategyForStoreInspect;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyForStoreInspect.dynamicFormCode();
  }

  @Override
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    StoreInspectModel storeInspectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), StoreInspectModel.class);
    this.dynamicFormOperationStrategyForStoreInspect.onDynamicFormCreate(storeInspectModel, dynamicKey, parentCode, null);
  }

  @Override
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    StoreInspectModel storeInspectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), StoreInspectModel.class);
    this.dynamicFormOperationStrategyForStoreInspect.onDynamicFormModify(storeInspectModel, dynamicKey, parentCode, null);
  }

  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyForStoreInspect.findByParentCode(dynamicKey, parentCode);
  }
}
