package com.biz.crm.sfa.business.template.store.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 店铺检查实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInspectEntity", description = "店铺检查实体类")
@Entity
@TableName("sfa_store_inspect")
@Table(name = "sfa_store_inspect")
@org.hibernate.annotations.Table(appliesTo = "sfa_store_inspect", comment = "店铺检查表")
public class StoreInspectEntity extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = -246779396614017344L;
  /**
   * 站点编码
   */
  @Column(name = "client_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点编码'")
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @Column(name = "client_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点名称'")
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @Column(name = "client_type", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点类别'")
  @ApiModelProperty("站点名称")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @Column(name = "check_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '位置信息'")
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 用户姓名
   */
  @Column(name = "user_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '用户姓名'")
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @Column(name = "user_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '用户编码'")
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @Column(name = "post_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位编码'")
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @Column(name = "post_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位名称'")
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 组织编码
   */
  @Column(name = "org_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '组织编码'")
  @ApiModelProperty("职位编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @Column(name = "org_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '组织名称'")
  @ApiModelProperty("职位名称")
  private String orgName;

  /**
   * 货架陈列图片列表
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("货架陈列图片列表")
  private List<StoreInspectFileEntity> shelvesDisplayPictures;

  /**
   * 物料陈列图片列表
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("物料陈列图片列表")
  private List<StoreInspectFileEntity> materialDisplayPictures;

  /**
   * 价格标签图片列表
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("价格标签图片列表")
  private List<StoreInspectFileEntity> priceTagPictures;

}
