package com.biz.crm.sfa.business.template.store.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 店铺检查文件实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInspectFileEntity", description = "店铺检查实体类")
@Entity
@TableName("sfa_store_inspect_file")
@Table(name = "sfa_store_inspect_file")
@org.hibernate.annotations.Table(appliesTo = "sfa_store_inspect_file", comment = "店铺检查文件表")
public class StoreInspectFileEntity extends FileEntity {
  /**
   * 店铺检查id
   */
  @Column(name = "store_inspect_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '店铺检查id'")
  @ApiModelProperty("店铺检查id")
  private String storeInspectId;

  /**
   * 店铺检查图片类型
   */
  @Column(name = "inspect_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '店铺检查图片类型'")
  @ApiModelProperty("店铺检查图片类型")
  private String inspectType;



}
