package com.biz.crm.sfa.business.template.store.local.model;


import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleUploadWidget;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 库存盘点Model
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInspectModel", description = "库存盘点Model")
public class StoreInspectModel extends AbstractDynamicTemplateModel implements DynamicForm {

  private static final long serialVersionUID = -7982168818414778058L;
  /**
   * 站点名称
   */
  @DynamicField(fieldName = "站点名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 位置信息
   */
  @DynamicField(fieldName = "位置信息", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 用户姓名
   */
  @DynamicField(fieldName = "用户姓名", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @DynamicField(fieldName = "用户编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @DynamicField(fieldName = "职位编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @DynamicField(fieldName = "职位名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 检查时间
   */
  @DynamicField(fieldName = "检查时间", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @ApiModelProperty("检查时间")
  private Date createTime;

  /**
   * 店铺检查货架陈列文件列表
   */
  @ApiModelProperty("货架陈列列表")
  @DynamicField(fieldName = "货架陈列列表", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleUploadWidget.class)
  private List<StoreInspectFileModel> shelvesDisplayPictures;

  /**
   * 店铺检查物料陈列文件列表
   */
  @ApiModelProperty("物料陈列列表")
  @DynamicField(fieldName = "物料陈列列表", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleUploadWidget.class)
  private List<StoreInspectFileModel> materialDisplayPictures;

  /**
   * 店铺检查价签陈列文件列表
   */
  @ApiModelProperty("价签陈列列表")
  @DynamicField(fieldName = "价签陈列列表", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleUploadWidget.class)
  private List<StoreInspectFileModel> priceTagPictures;

}
