package com.biz.crm.sfa.business.template.store.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.store.inspect.sdk.dto.StoreInspectDto;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import org.springframework.data.domain.Pageable;

/**
 * 店铺检查接口
 */
public interface StoreInspectService {

  /**
   * 创建店铺检查
   * @param StoreInspectEntity 店铺检查实体
   * @return 创建结果
   */
  StoreInspectEntity create(StoreInspectEntity StoreInspectEntity);

  /**
   * 更新店铺检查
   * @param StoreInspectEntity 店铺检查实体
   * @return 更新结果
   */
  StoreInspectEntity update(StoreInspectEntity StoreInspectEntity);

  /**
   * 分页查询店铺检查列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 店铺检查列表
   */
  Page<StoreInspectEntity> findByConditions(Pageable pageable, StoreInspectDto dto);

  /**
   * 根据id查询店铺检查详情
   * @param id id
   * @return 店铺检查详情
   */
  StoreInspectEntity findDetailById(String id);
}
