package com.biz.crm.sfa.business.template.store.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.store.inspect.sdk.dto.StoreInspectDto;
import com.biz.crm.sfa.business.template.store.inspect.sdk.eunms.StoreInspectTypeEnum;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import com.biz.crm.sfa.business.template.store.local.repository.StoreInspectFileRepository;
import com.biz.crm.sfa.business.template.store.local.repository.StoreInspectRepository;
import com.biz.crm.sfa.business.template.store.local.service.StoreInspectService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 店面检查接口实现类
 */
@Service
public class StoreInspectServiceImpl implements StoreInspectService {

  @Autowired
  private StoreInspectRepository storeInspectRepository;

  @Autowired
  private StoreInspectFileRepository storeInspectFileRepository;

  @Autowired
  private LoginUserService loginUserService;

  @Override
  @Transactional
  public StoreInspectEntity create(StoreInspectEntity storeInspectEntity) {
    this.validateCreateData(storeInspectEntity);
    if (!StringUtils.isAnyBlank(storeInspectEntity.getParentCode(), storeInspectEntity.getDynamicKey())) {
      StoreInspectEntity existEntity = this.storeInspectRepository.findByParentCodeAndDynamicKey(storeInspectEntity.getParentCode(), storeInspectEntity.getDynamicKey());
      Validate.isTrue(ObjectUtils.isEmpty(existEntity), "此业务已经提交过");
    }
    this.storeInspectRepository.save(storeInspectEntity);
    //保存货架陈列，物料陈列，价签陈列照片
    return createStoreInspectFile(storeInspectEntity);
  }

  @Override
  @Transactional
  public StoreInspectEntity update(StoreInspectEntity StoreInspectEntity) {
    this.validateCreateData(StoreInspectEntity);
    Validate.notNull(StoreInspectEntity.getId(), "待更新的数据不存在！");
    this.storeInspectRepository.saveOrUpdate(StoreInspectEntity);
    this.storeInspectFileRepository.deleteByCheckId(StoreInspectEntity.getId());
    return createStoreInspectFile(StoreInspectEntity);
  }

  /**
   * 保存店铺检查图片
   *
   * @param StoreInspectEntity 店铺检查实体
   * @return 保存结果
   */
  private StoreInspectEntity createStoreInspectFile(StoreInspectEntity StoreInspectEntity) {
    StoreInspectEntity.getMaterialDisplayPictures().forEach(detail -> {
      detail.setStoreInspectId(StoreInspectEntity.getId());
      detail.setInspectType(StoreInspectTypeEnum.MATERIAL_DISPLAY.getDictCode());
      detail.setTenantCode(TenantUtils.getTenantCode());
    });
    this.storeInspectFileRepository.saveBatch(StoreInspectEntity.getMaterialDisplayPictures());
    StoreInspectEntity.getShelvesDisplayPictures().forEach(detail -> {
      detail.setStoreInspectId(StoreInspectEntity.getId());
      detail.setInspectType(StoreInspectTypeEnum.SHELVES_DISPLAY.getDictCode());
      detail.setTenantCode(TenantUtils.getTenantCode());
    });
    this.storeInspectFileRepository.saveBatch(StoreInspectEntity.getShelvesDisplayPictures());
    StoreInspectEntity.getPriceTagPictures().forEach(detail -> {
      detail.setStoreInspectId(StoreInspectEntity.getId());
      detail.setInspectType(StoreInspectTypeEnum.PRICE_TAG_DISPLAY.getDictCode());
      detail.setTenantCode(TenantUtils.getTenantCode());
    });
    this.storeInspectFileRepository.saveBatch(StoreInspectEntity.getPriceTagPictures());
    return StoreInspectEntity;
  }

  @Override
  public Page<StoreInspectEntity> findByConditions(Pageable pageable, StoreInspectDto dto) {
    return this.storeInspectRepository.findByConditions(pageable, dto);
  }

  @Override
  public StoreInspectEntity findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    StoreInspectEntity StoreInspectEntity = this.storeInspectRepository.getById(id);
    if (ObjectUtils.isEmpty(StoreInspectEntity)) {
      return null;
    }
    StoreInspectEntity.setMaterialDisplayPictures(this.storeInspectFileRepository.findByCheckIdAndInspectType(StoreInspectEntity.getId(), StoreInspectTypeEnum.MATERIAL_DISPLAY.getDictCode()));
    StoreInspectEntity.setShelvesDisplayPictures(this.storeInspectFileRepository.findByCheckIdAndInspectType(StoreInspectEntity.getId(), StoreInspectTypeEnum.SHELVES_DISPLAY.getDictCode()));
    StoreInspectEntity.setPriceTagPictures(this.storeInspectFileRepository.findByCheckIdAndInspectType(StoreInspectEntity.getId(), StoreInspectTypeEnum.PRICE_TAG_DISPLAY.getDictCode()));
    return StoreInspectEntity;
  }


  /**
   * 校验店面检查创建数据
   *
   * @param storeInspectEntity 店面检查实体
   */
  private void validateCreateData(StoreInspectEntity storeInspectEntity) {
    Validate.notNull(storeInspectEntity, "店面检查实体不能为空！");
    Validate.notNull(storeInspectEntity.getClientCode(), "站点编码不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(storeInspectEntity.getShelvesDisplayPictures()) && storeInspectEntity.getShelvesDisplayPictures().size() < 6, "请上传货架陈列并最多5张");
    Validate.isTrue(CollectionUtils.isNotEmpty(storeInspectEntity.getMaterialDisplayPictures()) && storeInspectEntity.getMaterialDisplayPictures().size() < 6, "请上传物料陈列并最多5张");
    Validate.isTrue(CollectionUtils.isNotEmpty(storeInspectEntity.getPriceTagPictures()) && storeInspectEntity.getPriceTagPictures().size() < 6, "请上传价签陈列并最多5张");
    //构造基础数据
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    storeInspectEntity.setUserCode(loginDetails.getAccount());
    storeInspectEntity.setUserName(loginDetails.getRealName());
    storeInspectEntity.setPostCode(loginDetails.getPostCode());
    storeInspectEntity.setPostName(loginDetails.getPostName());
    storeInspectEntity.setTenantCode(loginDetails.getTenantCode());
    storeInspectEntity.setOrgCode(loginDetails.getOrgCode());
    storeInspectEntity.setOrgName(loginDetails.getOrgName());
  }
}
