/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.store.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.store.inspect.sdk.dto.StoreInspectDto;
import com.biz.crm.sfa.business.template.store.inspect.sdk.eunms.StoreInspectTypeEnum;
import com.biz.crm.sfa.business.template.store.local.entity.StoreInspectEntity;
import com.biz.crm.sfa.business.template.store.local.repository.StoreInspectFileRepository;
import com.biz.crm.sfa.business.template.store.local.repository.StoreInspectRepository;
import com.biz.crm.sfa.business.template.store.local.service.StoreInspectService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StoreInspectServiceImpl
implements StoreInspectService {
    @Autowired
    private StoreInspectRepository storeInspectRepository;
    @Autowired
    private StoreInspectFileRepository storeInspectFileRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public StoreInspectEntity create(StoreInspectEntity storeInspectEntity) {
        this.validateCreateData(storeInspectEntity);
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{storeInspectEntity.getParentCode(), storeInspectEntity.getDynamicKey()})) {
            StoreInspectEntity existEntity = this.storeInspectRepository.findByParentCodeAndDynamicKey(storeInspectEntity.getParentCode(), storeInspectEntity.getDynamicKey());
            Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)existEntity)), (String)"\u6b64\u4e1a\u52a1\u5df2\u7ecf\u63d0\u4ea4\u8fc7", (Object[])new Object[0]);
        }
        this.storeInspectRepository.save((Object)storeInspectEntity);
        return this.createStoreInspectFile(storeInspectEntity);
    }

    @Override
    @Transactional
    public StoreInspectEntity update(StoreInspectEntity StoreInspectEntity2) {
        this.validateCreateData(StoreInspectEntity2);
        Validate.notNull((Object)StoreInspectEntity2.getId(), (String)"\u5f85\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.storeInspectRepository.saveOrUpdate((Object)StoreInspectEntity2);
        this.storeInspectFileRepository.deleteByCheckId(StoreInspectEntity2.getId());
        return this.createStoreInspectFile(StoreInspectEntity2);
    }

    private StoreInspectEntity createStoreInspectFile(StoreInspectEntity StoreInspectEntity2) {
        StoreInspectEntity2.getMaterialDisplayPictures().forEach(detail -> {
            detail.setStoreInspectId(StoreInspectEntity2.getId());
            detail.setInspectType(StoreInspectTypeEnum.MATERIAL_DISPLAY.getDictCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
        });
        this.storeInspectFileRepository.saveBatch(StoreInspectEntity2.getMaterialDisplayPictures());
        StoreInspectEntity2.getShelvesDisplayPictures().forEach(detail -> {
            detail.setStoreInspectId(StoreInspectEntity2.getId());
            detail.setInspectType(StoreInspectTypeEnum.SHELVES_DISPLAY.getDictCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
        });
        this.storeInspectFileRepository.saveBatch(StoreInspectEntity2.getShelvesDisplayPictures());
        StoreInspectEntity2.getPriceTagPictures().forEach(detail -> {
            detail.setStoreInspectId(StoreInspectEntity2.getId());
            detail.setInspectType(StoreInspectTypeEnum.PRICE_TAG_DISPLAY.getDictCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
        });
        this.storeInspectFileRepository.saveBatch(StoreInspectEntity2.getPriceTagPictures());
        return StoreInspectEntity2;
    }

    @Override
    public Page<StoreInspectEntity> findByConditions(Pageable pageable, StoreInspectDto dto) {
        return this.storeInspectRepository.findByConditions(pageable, dto);
    }

    @Override
    public StoreInspectEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        StoreInspectEntity StoreInspectEntity2 = (StoreInspectEntity)((Object)this.storeInspectRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)StoreInspectEntity2))) {
            return null;
        }
        StoreInspectEntity2.setMaterialDisplayPictures(this.storeInspectFileRepository.findByCheckIdAndInspectType(StoreInspectEntity2.getId(), StoreInspectTypeEnum.MATERIAL_DISPLAY.getDictCode()));
        StoreInspectEntity2.setShelvesDisplayPictures(this.storeInspectFileRepository.findByCheckIdAndInspectType(StoreInspectEntity2.getId(), StoreInspectTypeEnum.SHELVES_DISPLAY.getDictCode()));
        StoreInspectEntity2.setPriceTagPictures(this.storeInspectFileRepository.findByCheckIdAndInspectType(StoreInspectEntity2.getId(), StoreInspectTypeEnum.PRICE_TAG_DISPLAY.getDictCode()));
        return StoreInspectEntity2;
    }

    private void validateCreateData(StoreInspectEntity storeInspectEntity) {
        Validate.notNull((Object)((Object)storeInspectEntity), (String)"\u5e97\u9762\u68c0\u67e5\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)storeInspectEntity.getClientCode(), (String)"\u7ad9\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((CollectionUtils.isNotEmpty(storeInspectEntity.getShelvesDisplayPictures()) && storeInspectEntity.getShelvesDisplayPictures().size() < 6 ? 1 : 0) != 0, (String)"\u8bf7\u4e0a\u4f20\u8d27\u67b6\u9648\u5217\u5e76\u6700\u591a5\u5f20", (Object[])new Object[0]);
        Validate.isTrue((CollectionUtils.isNotEmpty(storeInspectEntity.getMaterialDisplayPictures()) && storeInspectEntity.getMaterialDisplayPictures().size() < 6 ? 1 : 0) != 0, (String)"\u8bf7\u4e0a\u4f20\u7269\u6599\u9648\u5217\u5e76\u6700\u591a5\u5f20", (Object[])new Object[0]);
        Validate.isTrue((CollectionUtils.isNotEmpty(storeInspectEntity.getPriceTagPictures()) && storeInspectEntity.getPriceTagPictures().size() < 6 ? 1 : 0) != 0, (String)"\u8bf7\u4e0a\u4f20\u4ef7\u7b7e\u9648\u5217\u5e76\u6700\u591a5\u5f20", (Object[])new Object[0]);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        storeInspectEntity.setUserCode(loginDetails.getAccount());
        storeInspectEntity.setUserName(loginDetails.getRealName());
        storeInspectEntity.setPostCode(loginDetails.getPostCode());
        storeInspectEntity.setPostName(loginDetails.getPostName());
        storeInspectEntity.setTenantCode(loginDetails.getTenantCode());
        storeInspectEntity.setOrgCode(loginDetails.getOrgCode());
        storeInspectEntity.setOrgName(loginDetails.getOrgName());
    }
}

