package com.biz.crm.sfa.business.template.store.inspect.sdk.eunms;

import java.util.Arrays;
import java.util.Objects;

/**
 * 店铺检查文件类别
 *
 * @author jerry7
 */
public enum StoreInspectTypeEnum {
  SHELVES_DISPLAY("SHELVES", "SHELVES", "货架陈列", "1"),
  MATERIAL_DISPLAY("MATERIAL", "MATERIAL", "物料陈列", "2"),
  PRICE_TAG_DISPLAY("PRICE_TAG", "PRICE_TAG", "价签陈列", "3");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  StoreInspectTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 StoreInspectTypeEnum
   */
  public static StoreInspectTypeEnum getByKey(String key) {
    return Arrays.stream(StoreInspectTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 StoreInspectTypeEnum
   */
  public static StoreInspectTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(StoreInspectTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
