package com.biz.crm.sfa.business.template.store.inspect.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 店铺检查DTO
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "StoreInspectDTO", description = "店铺检查DTO")
public class StoreInspectDto extends AbstractDynamicTemplateEntity {

  /**
   * 站点编码
   */
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 用户姓名
   */
  @ApiModelProperty("用户姓名")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 创建人姓名
   */
  @ApiModelProperty("创建人姓名")
  private String createName;

  /**
   * 创建时间开始
   */
  @ApiModelProperty("创建时间查询开始")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 创建时间结束
   */
  @ApiModelProperty("创建时间查询结束")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

}
