package com.biz.crm.sfa.business.template.visit.conclusion.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import com.biz.crm.sfa.business.template.visit.conclusion.local.service.VisitConclusionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@Api(tags = "拜访总结：VisitConclusion:拜访总结")
@RequestMapping("/v1/visitConclusion/visitConclusion")
public class VisitConclusionController {

  @Autowired
  private VisitConclusionService visitConclusionService;

  /**
   * 创建工拜访总结
   *
   * @param entity 拜访总结
   * @return 创建结果
   */
  @ApiOperation("创建拜访总结")
  @PostMapping("")
  public Result<VisitConclusionEntity> create(@RequestBody VisitConclusionEntity entity) {
    return Result.ok(this.visitConclusionService.create(entity));
  }

  /**
   * 更新工拜访总结
   *
   * @param entity 拜访总结
   * @return 更新结果
   */
  @ApiOperation("更新拜访总结")
  @PatchMapping("")
  public Result<VisitConclusionEntity> update(@RequestBody VisitConclusionEntity entity) {
    return Result.ok(this.visitConclusionService.update(entity));
  }

  /**
   * 分页查询拜访总结列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 拜访总结列表
   */
  @ApiModelProperty("分页查询拜访总结列表")
  @GetMapping("findByConditions")
  public Result<Page<VisitConclusionEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "storeInspectDto", value = "分页Dto") VisitConclusionEntity dto) {
    return Result.ok(this.visitConclusionService.findByConditions(pageable, dto));
  }

  /**
   * 根据id查询拜访总结详情
   * @param id id
   * @return 拜访总结详情
   */
  @ApiModelProperty("查询拜访总结详情")
  @GetMapping("findDetailById")
  public Result<VisitConclusionEntity> findDetailById(@RequestParam("id")String id) {
    return Result.ok(this.visitConclusionService.findDetailById(id));
  }
}
