package com.biz.crm.sfa.business.template.visit.conclusion.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import com.biz.crm.sfa.business.template.visit.conclusion.local.mapper.VisitConclusionMapper;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 拜访总结数据操作repository
 *
 * @author jerry7
 */
@Component
public class VisitConclusionRepository extends ServiceImpl<VisitConclusionMapper, VisitConclusionEntity> {


  /**
   * 根据上级id和表单key查询拜访总结实体
   *
   * @param parentCode 上级id
   * @param dynamicKey 表单key
   * @return 拜访总结实体
   */
  public VisitConclusionEntity findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.lambdaQuery().eq(VisitConclusionEntity::getParentCode, parentCode)
            .eq(VisitConclusionEntity::getDynamicKey, dynamicKey)
            .one();
  }

  /**
   * 分页查询拜访总结列表
   *
   * @param pageable 分页信息
   * @param dto      查询参数
   * @return 拜访总结列表
   */
  public Page<VisitConclusionEntity> findByConditions(Pageable pageable, VisitConclusionEntity dto) {
    Page<VisitConclusionEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
