package com.biz.crm.sfa.business.template.visit.conclusion.local.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import org.springframework.data.domain.Pageable;

/**
 * 拜访评价接口
 */
public interface VisitConclusionService {

  /**
   * 创建拜访评价
   * @param VisitConclusionEntity 拜访评价实体
   * @return 创建结果
   */
  VisitConclusionEntity create(VisitConclusionEntity VisitConclusionEntity);

  /**
   * 更新拜访评价
   * @param VisitConclusionEntity 拜访评价实体
   * @return 更新结果
   */
  VisitConclusionEntity update(VisitConclusionEntity VisitConclusionEntity);

  /**
   * 分页查询拜访评价列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 拜访评价列表
   */
  Page<VisitConclusionEntity> findByConditions(Pageable pageable, VisitConclusionEntity dto);

  /**
   * 根据id查询拜访评价详情
   * @param id id
   * @return 拜访评价详情
   */
  VisitConclusionEntity findDetailById(String id);
}
