package com.biz.crm.sfa.business.template.visit.conclusion.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import com.biz.crm.sfa.business.template.visit.conclusion.local.repository.VisitConclusionRepository;
import com.biz.crm.sfa.business.template.visit.conclusion.local.service.VisitConclusionService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 拜访评价接口实现类
 */
@Service
public class VisitConclusionServiceImpl implements VisitConclusionService {

  @Autowired
  private VisitConclusionRepository storeInspectRepository;

  @Autowired
  private LoginUserService loginUserService;

  @Override
  @Transactional
  public VisitConclusionEntity create(VisitConclusionEntity visitConclusionEntity) {
    this.validateCreateData(visitConclusionEntity);
    if (!StringUtils.isAnyBlank(visitConclusionEntity.getParentCode(), visitConclusionEntity.getDynamicKey())) {
      VisitConclusionEntity existEntity = this.storeInspectRepository.findByParentCodeAndDynamicKey(visitConclusionEntity.getParentCode(), visitConclusionEntity.getDynamicKey());
      Validate.isTrue(ObjectUtils.isEmpty(existEntity), "此业务已经提交过");
    }
    this.storeInspectRepository.save(visitConclusionEntity);
    return visitConclusionEntity;
  }

  @Override
  @Transactional
  public VisitConclusionEntity update(VisitConclusionEntity visitConclusionEntity) {
    this.validateCreateData(visitConclusionEntity);
    Validate.notNull(visitConclusionEntity.getId(), "待更新的数据不存在！");
    this.storeInspectRepository.saveOrUpdate(visitConclusionEntity);
    return visitConclusionEntity;
  }

  @Override
  public Page<VisitConclusionEntity> findByConditions(Pageable pageable, VisitConclusionEntity dto) {
    return this.storeInspectRepository.findByConditions(pageable, dto);
  }

  @Override
  public VisitConclusionEntity findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.storeInspectRepository.getById(id);
  }


  /**
   * 校验拜访评价创建数据
   *
   * @param visitConclusionEntity 拜访评价实体
   */
  private void validateCreateData(VisitConclusionEntity visitConclusionEntity) {
    Validate.notNull(visitConclusionEntity, "拜访评价实体不能为空！");
    Validate.notNull(visitConclusionEntity.getClientCode(), "站点编码不能为空");
    Validate.notNull(visitConclusionEntity.getConclusionContent(), "拜访总结内容不能为空");
    Validate.isTrue(visitConclusionEntity.getConclusionContent().length() < 201, "拜访总结内容不能超过200字");
    //构造基础数据
    LoginUserDetails loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    visitConclusionEntity.setUserCode(loginUserDetails.getAccount());
    visitConclusionEntity.setUserName(loginUserDetails.getRealName());
    visitConclusionEntity.setPostCode(loginUserDetails.getPostCode());
    visitConclusionEntity.setPostName(loginUserDetails.getPostName());
    visitConclusionEntity.setCreateTime(DateUtil.date());
    visitConclusionEntity.setTenantCode(loginUserDetails.getTenantCode());
  }
}
