/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.visit.conclusion.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import com.biz.crm.sfa.business.template.visit.conclusion.local.repository.VisitConclusionRepository;
import com.biz.crm.sfa.business.template.visit.conclusion.local.service.VisitConclusionService;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisitConclusionServiceImpl
implements VisitConclusionService {
    @Autowired
    private VisitConclusionRepository storeInspectRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public VisitConclusionEntity create(VisitConclusionEntity visitConclusionEntity) {
        this.validateCreateData(visitConclusionEntity);
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{visitConclusionEntity.getParentCode(), visitConclusionEntity.getDynamicKey()})) {
            VisitConclusionEntity existEntity = this.storeInspectRepository.findByParentCodeAndDynamicKey(visitConclusionEntity.getParentCode(), visitConclusionEntity.getDynamicKey());
            Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)existEntity)), (String)"\u6b64\u4e1a\u52a1\u5df2\u7ecf\u63d0\u4ea4\u8fc7", (Object[])new Object[0]);
        }
        this.storeInspectRepository.save((Object)visitConclusionEntity);
        return visitConclusionEntity;
    }

    @Override
    @Transactional
    public VisitConclusionEntity update(VisitConclusionEntity visitConclusionEntity) {
        this.validateCreateData(visitConclusionEntity);
        Validate.notNull((Object)visitConclusionEntity.getId(), (String)"\u5f85\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.storeInspectRepository.saveOrUpdate((Object)visitConclusionEntity);
        return visitConclusionEntity;
    }

    @Override
    public Page<VisitConclusionEntity> findByConditions(Pageable pageable, VisitConclusionEntity dto) {
        return this.storeInspectRepository.findByConditions(pageable, dto);
    }

    @Override
    public VisitConclusionEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (VisitConclusionEntity)((Object)this.storeInspectRepository.getById((Serializable)((Object)id)));
    }

    private void validateCreateData(VisitConclusionEntity visitConclusionEntity) {
        Validate.notNull((Object)((Object)visitConclusionEntity), (String)"\u62dc\u8bbf\u8bc4\u4ef7\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)visitConclusionEntity.getClientCode(), (String)"\u7ad9\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)visitConclusionEntity.getConclusionContent(), (String)"\u62dc\u8bbf\u603b\u7ed3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((visitConclusionEntity.getConclusionContent().length() < 201 ? 1 : 0) != 0, (String)"\u62dc\u8bbf\u603b\u7ed3\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u5b57", (Object[])new Object[0]);
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        visitConclusionEntity.setUserCode(loginUserDetails.getAccount());
        visitConclusionEntity.setUserName(loginUserDetails.getRealName());
        visitConclusionEntity.setPostCode(loginUserDetails.getPostCode());
        visitConclusionEntity.setPostName(loginUserDetails.getPostName());
        visitConclusionEntity.setCreateTime((Date)DateUtil.date());
        visitConclusionEntity.setTenantCode(loginUserDetails.getTenantCode());
    }
}

