package com.biz.crm.sfa.business.template.visit.conclusion.local.model;


import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleTextAreaWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleUploadWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * 拜访总结Model
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitConclusionModel", description = "拜访总结Model")
public class VisitConclusionModel extends AbstractDynamicTemplateModel implements DynamicForm {

  /**
   * 站点编码
   */
  @DynamicField(fieldName = "站点编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @DynamicField(fieldName = "站点名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @DynamicField(fieldName = "站点类别", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点类别")
  private String clientType;

  /**
   * 站点名称
   */
  @DynamicField(fieldName = "站点名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点名称")
  private String lastConclusionContent;

  /**
   * 拜访总结
   */
  @DynamicField(fieldName = "拜访总结", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleTextAreaWidget.class)
  @ApiModelProperty("拜访总结")
  private String conclusionContent;



}
