package com.biz.crm.sfa.business.template.visit.conclusion.local.service.internal;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import com.biz.crm.sfa.business.template.visit.conclusion.local.model.VisitConclusionModel;
import com.biz.crm.sfa.business.template.visit.conclusion.local.repository.VisitConclusionRepository;
import com.biz.crm.sfa.business.template.visit.conclusion.local.service.VisitConclusionModelService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 拜访总结model接口实现
 */
@Service
public class VisitConclusionModelServiceImpl implements VisitConclusionModelService {

  @Autowired
  private VisitConclusionRepository storeInspectRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public VisitConclusionModel findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    if (StringUtils.isAnyEmpty(parentCode, dynamicKey)) {
      return null;
    }
    VisitConclusionEntity visitConclusionEntity = this.storeInspectRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    if (ObjectUtils.isEmpty(visitConclusionEntity)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(visitConclusionEntity, VisitConclusionModel.class, HashSet.class, ArrayList.class);
  }
}
