package com.biz.crm.sfa.business.template.visit.conclusion.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.visit.conclusion.local.entity.VisitConclusionEntity;
import com.biz.crm.sfa.business.template.visit.conclusion.local.model.VisitConclusionModel;
import com.biz.crm.sfa.business.template.visit.conclusion.local.service.VisitConclusionModelService;
import com.biz.crm.sfa.business.template.visit.conclusion.local.service.VisitConclusionService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

@Component
public class DynamicFormOperationStrategyForVisitConclusion implements DynamicFormOperationStrategy<VisitConclusionModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;

  @Autowired
  private VisitConclusionService storeInspectService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitConclusionModelService visitConclusionModelService;

  @Override
  public void onDynamicFormCreate(VisitConclusionModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    VisitConclusionEntity visitConclusionEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, VisitConclusionEntity.class, HashSet.class, ArrayList.class);
    this.storeInspectService.create(visitConclusionEntity);
  }

  @Override
  public void onDynamicFormModify(VisitConclusionModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    VisitConclusionEntity visitConclusionEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, VisitConclusionEntity.class, HashSet.class, ArrayList.class);
    this.storeInspectService.update(visitConclusionEntity);
  }

  @Override
  public VisitConclusionModel findByParentCode(String dynamicKey, String parentCode) {
    if (StringUtils.isAnyBlank(dynamicKey, parentCode)) {
      return null;
    }
    return this.visitConclusionModelService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "拜访总结";
  }

  @Override
  public Class<VisitConclusionModel> dynamicFormClass() {
    return VisitConclusionModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {

  }

  @Override
  public int getOrder() {
    return 13;
  }
}
