/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.visit.evaluate.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.repository.VisitEvaluateRepository;
import com.biz.crm.sfa.business.template.visit.evaluate.local.repository.VisitEvaluateStepRepository;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateService;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.dto.VisitEvaluateDto;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.listener.HelpDefenseListener;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class VisitEvaluateServiceImpl
implements VisitEvaluateService {
    @Autowired
    private VisitEvaluateRepository visitEvaluateRepository;
    @Autowired
    private VisitEvaluateStepRepository visitEvaluateStepRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private HelpDefenseListener helpDefenseListener;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    @Transactional
    public VisitEvaluateEntity create(VisitEvaluateEntity visitEvaluateEntity) {
        this.validateCreateData(visitEvaluateEntity);
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{visitEvaluateEntity.getParentCode(), visitEvaluateEntity.getDynamicKey()})) {
            VisitEvaluateEntity existEntity = this.visitEvaluateRepository.findByParentCodeAndDynamicKey(visitEvaluateEntity.getParentCode(), visitEvaluateEntity.getDynamicKey());
            Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)existEntity)), (String)"\u6b64\u4e1a\u52a1\u5df2\u7ecf\u63d0\u4ea4\u8fc7", (Object[])new Object[0]);
        }
        this.visitEvaluateRepository.save((Object)visitEvaluateEntity);
        visitEvaluateEntity.getStepDetails().forEach(step -> step.setVisitEvaluateId(visitEvaluateEntity.getId()));
        this.visitEvaluateStepRepository.saveOrUpdateBatch(visitEvaluateEntity.getStepDetails());
        return visitEvaluateEntity;
    }

    @Override
    @Transactional
    public VisitEvaluateEntity update(VisitEvaluateEntity visitEvaluateEntity) {
        this.validateCreateData(visitEvaluateEntity);
        Validate.notNull((Object)visitEvaluateEntity.getId(), (String)"\u5f85\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.visitEvaluateRepository.saveOrUpdate((Object)visitEvaluateEntity);
        this.visitEvaluateStepRepository.deleteByEvaluate(visitEvaluateEntity.getId());
        visitEvaluateEntity.getStepDetails().forEach(step -> step.setVisitEvaluateId(visitEvaluateEntity.getId()));
        this.visitEvaluateStepRepository.saveOrUpdateBatch(visitEvaluateEntity.getStepDetails());
        return visitEvaluateEntity;
    }

    @Override
    public Page<VisitEvaluateEntity> findByConditions(Pageable pageable, VisitEvaluateDto dto) {
        return this.visitEvaluateRepository.findByConditions(pageable, dto);
    }

    @Override
    public VisitEvaluateEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VisitEvaluateEntity visitEvaluateEntity = (VisitEvaluateEntity)((Object)this.visitEvaluateRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)visitEvaluateEntity))) {
            return null;
        }
        visitEvaluateEntity.setStepDetails(this.visitEvaluateStepRepository.findByEvaluateId(id));
        return visitEvaluateEntity;
    }

    private void validateCreateData(VisitEvaluateEntity visitEvaluateEntity) {
        Validate.notNull((Object)((Object)visitEvaluateEntity), (String)"\u534f\u8bbf\u8bc4\u4ef7\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)visitEvaluateEntity.getClientCode(), (String)"\u7ad9\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(visitEvaluateEntity.getStepDetails(), (String)"\u534f\u8bbf\u6b65\u9aa4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)visitEvaluateEntity.getVisitContent(), (String)"\u62dc\u8bbf\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((visitEvaluateEntity.getVisitContent().length() <= 200 ? 1 : 0) != 0, (String)"\u62dc\u8bbf\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u5b57", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)visitEvaluateEntity.getProblemContent())) {
            Validate.isTrue((visitEvaluateEntity.getProblemContent().length() <= 200 ? 1 : 0) != 0, (String)"\u95ee\u9898\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u5b57", (Object[])new Object[0]);
        }
        List passList = visitEvaluateEntity.getStepDetails().stream().filter(visitEvaluateStepEntity -> visitEvaluateStepEntity.getStepResult().equals("1")).collect(Collectors.toList());
        visitEvaluateEntity.setQualifiedRate(new BigDecimal(passList.size()).divide(new BigDecimal(visitEvaluateEntity.getStepDetails().size()), 2, 4).toString());
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        visitEvaluateEntity.setHelpUserCode(loginUserDetails.getAccount());
        visitEvaluateEntity.setHelpUserName(loginUserDetails.getRealName());
        visitEvaluateEntity.setHelpPostCode(loginUserDetails.getPostCode());
        visitEvaluateEntity.setHelpPostName(loginUserDetails.getPostName());
        visitEvaluateEntity.setHelpOrgCode(loginUserDetails.getOrgCode());
        visitEvaluateEntity.setHelpOrgName(loginUserDetails.getOrgName());
        visitEvaluateEntity.setCreateTime((Date)DateUtil.date());
        visitEvaluateEntity.setTenantCode(loginUserDetails.getTenantCode());
        String coverHelpUserName = this.helpDefenseListener.getCoverHelpUserNameByParentCode(visitEvaluateEntity.getParentCode());
        if (StringUtils.isBlank((CharSequence)coverHelpUserName)) {
            return;
        }
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList((Object[])new String[]{coverHelpUserName}));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        UserVo userVo = (UserVo)userVoList.stream().findFirst().get();
        visitEvaluateEntity.setCoverHelpUserCode(userVo.getUserCode());
        visitEvaluateEntity.setCoverHelpUserName(userVo.getUserName());
        visitEvaluateEntity.setCoverHelpPostCode(userVo.getPositionCode());
        visitEvaluateEntity.setCoverHelpPostName(userVo.getPositionName());
        visitEvaluateEntity.setCoverHelpOrgCode(userVo.getOrgCode());
        visitEvaluateEntity.setCoverHelpOrgName(userVo.getOrgName());
    }
}

