package com.biz.crm.sfa.business.template.visit.evaluate.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateService;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.dto.VisitEvaluateDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@Api(tags = "协访评价：visitEvaluate:协访评价")
@RequestMapping("/v1/visitEvaluate/visitEvaluate")
public class VisitEvaluateController {

  @Autowired
  private VisitEvaluateService visitEvaluateService;

  /**
   * 创建工协访评价
   *
   * @param entity 协访评价
   * @return 创建结果
   */
  @ApiOperation("创建协访评价")
  @PostMapping("")
  public Result<VisitEvaluateEntity> create(@RequestBody VisitEvaluateEntity entity) {
    return Result.ok(this.visitEvaluateService.create(entity));
  }

  /**
   * 更新工协访评价
   *
   * @param entity 协访评价
   * @return 更新结果
   */
  @ApiOperation("更新协访评价")
  @PatchMapping("")
  public Result<VisitEvaluateEntity> update(@RequestBody VisitEvaluateEntity entity) {
    return Result.ok(this.visitEvaluateService.update(entity));
  }

  /**
   * 分页查询协访评价列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 协访评价列表
   */
  @ApiOperation("分页查询协访评价列表")
  @GetMapping("findByConditions")
  public Result<Page<VisitEvaluateEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "VisitEvaluateDto", value = "分页Dto") VisitEvaluateDto dto) {
    return Result.ok(this.visitEvaluateService.findByConditions(pageable, dto));
  }

  /**
   * 根据id查询协访评价详情
   * @param id id
   * @return 协访评价详情
   */
  @ApiOperation("查询协访评价详情")
  @GetMapping("findDetailById")
  public Result<VisitEvaluateEntity> findDetailById(@RequestParam("id")String id) {
    return Result.ok(this.visitEvaluateService.findDetailById(id));
  }
}
