package com.biz.crm.sfa.business.template.visit.evaluate.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 协访评价实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitEvaluateEntity", description = "协访评价实体类")
@Entity
@TableName("sfa_visit_evaluate")
@Table(name = "sfa_visit_evaluate")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_evaluate", comment = "协访评价表")
public class VisitEvaluateEntity extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = -8528283005139138116L;
  /**
   * 站点编码
   */
  @Column(name = "client_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点编码'")
  @ApiModelProperty("站点编码")
  private String clientCode;

  /**
   * 站点名称
   */
  @Column(name = "client_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '站点名称'")
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 站点类别
   */
  @Column(name = "client_type", length = 32, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '站点类别(经销商/终端)'")
  @ApiModelProperty("站点类别(经销商/终端)")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @Column(name = "check_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '位置信息'")
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 协访用户姓名
   */
  @Column(name = "help_user_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访用户姓名'")
  @ApiModelProperty("协访用户姓名")
  private String helpUserName;

  /**
   * 协访用户编码
   */
  @Column(name = "help_user_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访用户编码'")
  @ApiModelProperty("协访用户编码")
  private String helpUserCode;

  /**
   * 协访职位编码
   */
  @Column(name = "help_post_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访职位编码'")
  @ApiModelProperty("协访职位编码")
  private String helpPostCode;

  /**
   * 协访职位名称
   */
  @Column(name = "help_post_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访职位名称'")
  @ApiModelProperty("协访职位名称")
  private String helpPostName;

  /**
   * 协访组织编码
   */
  @Column(name = "help_org_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访组织编码'")
  @ApiModelProperty("协访组织编码")
  private String helpOrgCode;

  /**
   * 协访组织名称
   */
  @Column(name = "help_org_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访组织名称'")
  @ApiModelProperty("协访组织名称")
  private String helpOrgName;

  /**
   * 被协访用户姓名
   */
  @Column(name = "cover_help_user_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '被协访用户姓名'")
  @ApiModelProperty("被协访用户姓名")
  private String coverHelpUserName;

  /**
   * 被协访用户编码
   */
  @Column(name = "cover_help_user_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '被协访用户编码'")
  @ApiModelProperty("被协访用户编码")
  private String coverHelpUserCode;

  /**
   * 被协访职位编码
   */
  @Column(name = "cover_help_post_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '被协访职位编码'")
  @ApiModelProperty("被协访职位编码")
  private String coverHelpPostCode;

  /**
   * 被协访职位名称
   */
  @Column(name = "cover_help_post_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '被协访职位名称'")
  @ApiModelProperty("被协访职位名称")
  private String coverHelpPostName;

  /**
   * 被协访组织编码
   */
  @Column(name = "cover_help_org_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '被协访组织编码'")
  @ApiModelProperty("被协访组织编码")
  private String coverHelpOrgCode;

  /**
   * 被协访组织名称
   */
  @Column(name = "cover_help_org_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '被协访组织名称'")
  @ApiModelProperty("被协访组织名称")
  private String coverHelpOrgName;

  /**
   * 拜访内容
   */
  @Column(name = "visit_content", columnDefinition = "VARCHAR(200) NOT NULL COMMENT '拜访内容'")
  @ApiModelProperty("拜访内容")
  private String visitContent;

  /**
   * 问题内容
   */
  @Column(name = "problem_content", columnDefinition = "VARCHAR(200) NOT NULL COMMENT '问题内容'")
  @ApiModelProperty("问题内容")
  private String problemContent;

  /**
   * 合格率
   */
  @ApiModelProperty("合格率")
  @Column(name = "qualified_rate", columnDefinition = "VARCHAR(12) NOT NULL COMMENT '合格率'")
  private String qualifiedRate;

  /**
   * 协访步骤
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("协访步骤")
  private List<VisitEvaluateStepEntity> stepDetails;

}
