package com.biz.crm.sfa.business.template.visit.evaluate.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleEvaluateWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 协访评价实体类
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitEvaluateStepEntity", description = "协访评价步骤实体类")
@Entity
@TableName("sfa_visit_evaluate_step")
@Table(name = "sfa_visit_evaluate_step")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_evaluate_step", comment = "协访评价步骤表")
public class VisitEvaluateStepEntity extends UuidEntity {

  /**
   * 协访评价id
   */
  @Column(name = "visit_evaluate_id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '协访评价id'")
  @ApiModelProperty("协访评价id")
  private String visitEvaluateId;

  /**
   * 步骤编码
   */
  @Column(name = "step_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '步骤编码'")
  @ApiModelProperty("步骤编码")
  private String stepCode;

  /**
   * 步骤名称
   */
  @Column(name = "step_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '步骤名称'")
  @ApiModelProperty("步骤名称")
  private String stepName;

  /**
   * 步骤结果(合格/不合格)
   */
  @Column(name = "step_result", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '步骤结果(合格/不合格)'")
  @ApiModelProperty("步骤结果(合格/不合格)")
  private String stepResult;

  /**
   * 步骤排序
   */
  @Column(name = "step_order", length = 64, columnDefinition = "int(4) NOT NULL COMMENT '步骤排序'")
  @ApiModelProperty("步骤排序")
  private int stepOrder;



}
