package com.biz.crm.sfa.business.template.visit.evaluate.local.model;


import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleTextAreaWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleVisitStepsSelectWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 协访评价Model
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitEvaluateModel", description = "协访评价Model")
public class VisitEvaluateModel extends AbstractDynamicTemplateModel implements DynamicForm {

  private static final long serialVersionUID = -3501953856712071157L;
  /**
   * 站点名称
   */
  @DynamicField(fieldName = "站点名称", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("站点名称")
  private String clientName;


  /**
   * 位置信息
   */
  @DynamicField(fieldName = "位置信息", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("位置信息")
  private String checkAddress;

  /**
   * 拜访内容
   */
  @DynamicField(fieldName = "拜访内容", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleTextAreaWidget.class)
  @ApiModelProperty("拜访内容")
  private String visitContent;

  /**
   * 问题内容
   */
  @DynamicField(fieldName = "问题内容", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleTextAreaWidget.class)
  @ApiModelProperty("问题内容")
  private String problemContent;

  /**
   * 协访步骤列表
   */
  @ApiModelProperty("协访列表")
  @DynamicField(fieldName = "协访步骤列表", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleVisitStepsSelectWidget.class)
  private List<VisitEvaluateStepModel> stepDetails;

}
