package com.biz.crm.sfa.business.template.visit.evaluate.local.model;


import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleEvaluateWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
/**
 * 协访评价Model
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitEvaluateStepModel", description = "协访评价步骤Model")
public class VisitEvaluateStepModel {

  /**
   * 步骤编码
   */
  @DynamicField(fieldName = "协访评价id", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  @ApiModelProperty("步骤编码")
  private String stepCode;

  /**
   * 步骤名称
   */
  @DynamicField(fieldName = "协访评价id", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  @ApiModelProperty("步骤名称")
  private String stepName;

  /**
   * 步骤结果(合格/不合格)
   */
  @DynamicField(fieldName = "协访评价id", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleEvaluateWidget.class)
  @ApiModelProperty("步骤结果(合格/不合格)")
  private String stepResult;

  /**
   * 步骤排序
   */
  @DynamicField(fieldName = "步骤排序", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleEvaluateWidget.class)
  @ApiModelProperty("步骤排序")
  private int stepOrder;

}
