package com.biz.crm.sfa.business.template.visit.evaluate.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.mapper.VisitEvaluateMapper;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.dto.VisitEvaluateDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 协访评价数据操作repository
 *
 * @author jerry7
 */
@Component
public class VisitEvaluateRepository extends ServiceImpl<VisitEvaluateMapper, VisitEvaluateEntity> {


  /**
   * 根据上级id和表单key查询协访评价实体
   * @param parentCode 上级id
   * @param dynamicKey 表单key
   * @return 协访评价实体
   */
  public VisitEvaluateEntity findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.lambdaQuery().eq(VisitEvaluateEntity::getParentCode, parentCode)
            .eq(VisitEvaluateEntity::getDynamicKey, dynamicKey)
            .one();
  }

  /**
   * 分页查询协访评价列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 协访评价列表
   */
  public Page<VisitEvaluateEntity> findByConditions(Pageable pageable, VisitEvaluateDto dto){
    Page<VisitEvaluateEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
