package com.biz.crm.sfa.business.template.visit.evaluate.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateStepEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.mapper.VisitEvaluateStepMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 协访评价步骤数据操作repository
 *
 * @author jerry7
 */
@Component
public class VisitEvaluateStepRepository extends ServiceImpl<VisitEvaluateStepMapper, VisitEvaluateStepEntity> {

  /**
   * 根据协访评价id删除协访步骤列表
   *
   * @param evaluateId 协访评价id
   */
  public void deleteByEvaluate(String evaluateId) {
    this.lambdaUpdate().eq(VisitEvaluateStepEntity::getVisitEvaluateId, evaluateId).remove();
  }

  /**
   * 根据协访评价id查询协访评价详情列表
   *
   * @param evaluateId 协访评价id
   * @return 协访评价id列表
   */
  public List<VisitEvaluateStepEntity> findByEvaluateId(String evaluateId) {
    return this.lambdaQuery().eq(VisitEvaluateStepEntity::getVisitEvaluateId, evaluateId)
            .orderByAsc(VisitEvaluateStepEntity::getStepOrder)
            .list();
  }
}
