package com.biz.crm.sfa.business.template.visit.evaluate.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.dto.VisitEvaluateDto;
import org.springframework.data.domain.Pageable;

/**
 * 协访评价接口
 */
public interface VisitEvaluateService {

  /**
   * 创建协访评价
   * @param VisitEvaluateEntity 协访评价实体
   * @return 创建结果
   */
  VisitEvaluateEntity create(VisitEvaluateEntity VisitEvaluateEntity);

  /**
   * 更新协访评价
   * @param VisitEvaluateEntity 协访评价实体
   * @return 更新结果
   */
  VisitEvaluateEntity update(VisitEvaluateEntity VisitEvaluateEntity);

  /**
   * 分页查询协访评价列表
   * @param pageable 分页信息
   * @param dto 查询参数
   * @return 协访评价列表
   */
  Page<VisitEvaluateEntity> findByConditions(Pageable pageable, VisitEvaluateDto dto);

  /**
   * 根据id查询协访评价详情
   * @param id id
   * @return 协访评价详情
   */
  VisitEvaluateEntity findDetailById(String id);
}
