package com.biz.crm.sfa.business.template.visit.evaluate.local.service.internal;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.model.VisitEvaluateModel;
import com.biz.crm.sfa.business.template.visit.evaluate.local.repository.VisitEvaluateRepository;
import com.biz.crm.sfa.business.template.visit.evaluate.local.repository.VisitEvaluateStepRepository;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateModelService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 库存盘点model接口实现
 */
@Service
public class VisitEvaluateModelServiceImpl implements VisitEvaluateModelService {

  @Autowired
  private VisitEvaluateRepository visitEvaluateRepository;

  @Autowired
  private VisitEvaluateStepRepository visitEvaluateStepRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public VisitEvaluateModel findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    if (StringUtils.isAnyEmpty(parentCode, dynamicKey)) {
      return null;
    }
    VisitEvaluateEntity visitEvaluateEntity = this.visitEvaluateRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    if (ObjectUtils.isEmpty(visitEvaluateEntity)) {
      return null;
    }
    visitEvaluateEntity.setStepDetails(this.visitEvaluateStepRepository.findByEvaluateId(visitEvaluateEntity.getId()));
    return this.nebulaToolkitService.copyObjectByWhiteList(visitEvaluateEntity, VisitEvaluateModel.class, HashSet.class, ArrayList.class, "stepDetails");
  }
}
