package com.biz.crm.sfa.business.template.visit.evaluate.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateStepEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.repository.VisitEvaluateRepository;
import com.biz.crm.sfa.business.template.visit.evaluate.local.repository.VisitEvaluateStepRepository;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateService;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.dto.VisitEvaluateDto;
import com.biz.crm.sfa.business.template.visit.evaluate.sdk.listener.HelpDefenseListener;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 协访评价接口实现类
 */
@Service
public class VisitEvaluateServiceImpl implements VisitEvaluateService {

  @Autowired
  private VisitEvaluateRepository visitEvaluateRepository;

  @Autowired
  private VisitEvaluateStepRepository visitEvaluateStepRepository;

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private HelpDefenseListener helpDefenseListener;

  @Autowired
  private UserFeignVoService userFeignVoService;

  @Override
  @Transactional
  public VisitEvaluateEntity create(VisitEvaluateEntity visitEvaluateEntity) {
    this.validateCreateData(visitEvaluateEntity);
    if (!StringUtils.isAnyBlank(visitEvaluateEntity.getParentCode(), visitEvaluateEntity.getDynamicKey())) {
      VisitEvaluateEntity existEntity = this.visitEvaluateRepository.findByParentCodeAndDynamicKey(visitEvaluateEntity.getParentCode(), visitEvaluateEntity.getDynamicKey());
      Validate.isTrue(ObjectUtils.isEmpty(existEntity), "此业务已经提交过");
    }
    this.visitEvaluateRepository.save(visitEvaluateEntity);
    //保存协访步骤
    visitEvaluateEntity.getStepDetails().forEach(step -> step.setVisitEvaluateId(visitEvaluateEntity.getId()));
    this.visitEvaluateStepRepository.saveOrUpdateBatch(visitEvaluateEntity.getStepDetails());
    return visitEvaluateEntity;
  }

  @Override
  @Transactional
  public VisitEvaluateEntity update(VisitEvaluateEntity visitEvaluateEntity) {
    this.validateCreateData(visitEvaluateEntity);
    Validate.notNull(visitEvaluateEntity.getId(), "待更新的数据不存在！");
    this.visitEvaluateRepository.saveOrUpdate(visitEvaluateEntity);
    this.visitEvaluateStepRepository.deleteByEvaluate(visitEvaluateEntity.getId());
    //保存协访步骤
    visitEvaluateEntity.getStepDetails().forEach(step -> step.setVisitEvaluateId(visitEvaluateEntity.getId()));
    this.visitEvaluateStepRepository.saveOrUpdateBatch(visitEvaluateEntity.getStepDetails());
    return visitEvaluateEntity;
  }

  @Override
  public Page<VisitEvaluateEntity> findByConditions(Pageable pageable, VisitEvaluateDto dto) {
    return this.visitEvaluateRepository.findByConditions(pageable, dto);
  }

  @Override
  public VisitEvaluateEntity findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    VisitEvaluateEntity visitEvaluateEntity = this.visitEvaluateRepository.getById(id);
    if (ObjectUtils.isEmpty(visitEvaluateEntity)) {
      return null;
    }
    visitEvaluateEntity.setStepDetails(this.visitEvaluateStepRepository.findByEvaluateId(id));
    return visitEvaluateEntity;
  }


  /**
   * 校验协访评价创建数据
   *
   * @param visitEvaluateEntity 协访评价实体
   */
  private void validateCreateData(VisitEvaluateEntity visitEvaluateEntity) {
    Validate.notNull(visitEvaluateEntity, "协访评价实体不能为空！");
    Validate.notNull(visitEvaluateEntity.getClientCode(), "站点编码不能为空");
    Validate.notEmpty(visitEvaluateEntity.getStepDetails(), "协访步骤不能为空");
    Validate.notNull(visitEvaluateEntity.getVisitContent(), "拜访内容不能为空");
    Validate.isTrue(visitEvaluateEntity.getVisitContent().length() <= 200, "拜访内容不能超过200字");
    if (StringUtils.isNotBlank(visitEvaluateEntity.getProblemContent())) {
      Validate.isTrue(visitEvaluateEntity.getProblemContent().length() <= 200, "问题内容不能超过200字");
    }
    List<VisitEvaluateStepEntity> passList = visitEvaluateEntity.getStepDetails().stream().filter(visitEvaluateStepEntity ->
        visitEvaluateStepEntity.getStepResult().equals("1")
    ).collect(Collectors.toList());
    visitEvaluateEntity.setQualifiedRate(new BigDecimal(passList.size()).divide(new BigDecimal(visitEvaluateEntity.getStepDetails().size()), 2, BigDecimal.ROUND_HALF_UP).toString());
    //构造基础数据
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    visitEvaluateEntity.setHelpUserCode(loginDetails.getAccount());
    visitEvaluateEntity.setHelpUserName(loginDetails.getRealName());
    visitEvaluateEntity.setHelpPostCode(loginDetails.getPostCode());
    visitEvaluateEntity.setHelpPostName(loginDetails.getPostName());
    visitEvaluateEntity.setHelpOrgCode(loginDetails.getOrgCode());
    visitEvaluateEntity.setHelpOrgName(loginDetails.getOrgName());
    visitEvaluateEntity.setCreateTime(DateUtil.date());
    visitEvaluateEntity.setTenantCode(loginDetails.getTenantCode());
    //根据协访计划查询被协访人信息并记录
    String coverHelpUserName = this.helpDefenseListener.getCoverHelpUserNameByParentCode(visitEvaluateEntity.getParentCode());
    if (StringUtils.isBlank(coverHelpUserName)) {
      return;
    }
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(coverHelpUserName));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    UserVo userVo = userVoList.stream().findFirst().get();
    visitEvaluateEntity.setCoverHelpUserCode(userVo.getUserCode());
    visitEvaluateEntity.setCoverHelpUserName(userVo.getUserName());
    visitEvaluateEntity.setCoverHelpPostCode(userVo.getPositionCode());
    visitEvaluateEntity.setCoverHelpPostName(userVo.getPositionName());
    visitEvaluateEntity.setCoverHelpOrgCode(userVo.getOrgCode());
    visitEvaluateEntity.setCoverHelpOrgName(userVo.getOrgName());
  }
}
