package com.biz.crm.sfa.business.template.visit.evaluate.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.visit.evaluate.local.entity.VisitEvaluateEntity;
import com.biz.crm.sfa.business.template.visit.evaluate.local.model.VisitEvaluateModel;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateModelService;
import com.biz.crm.sfa.business.template.visit.evaluate.local.service.VisitEvaluateService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

@Component
public class DynamicFormOperationStrategyForVisitEvaluate implements DynamicFormOperationStrategy<VisitEvaluateModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;

  @Autowired
  private VisitEvaluateService visitEvaluateService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitEvaluateModelService visitEvaluateModelService;

  @Override
  public void onDynamicFormCreate(VisitEvaluateModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    VisitEvaluateEntity visitEvaluateEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, VisitEvaluateEntity.class, HashSet.class, ArrayList.class, "stepDetails");
    this.visitEvaluateService.create(visitEvaluateEntity);
  }

  @Override
  public void onDynamicFormModify(VisitEvaluateModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    VisitEvaluateEntity visitEvaluateEntity = this.nebulaToolkitService.copyObjectByWhiteList(dynamicForm, VisitEvaluateEntity.class, HashSet.class, ArrayList.class, "stepDetails");
    this.visitEvaluateService.update(visitEvaluateEntity);
  }

  @Override
  public VisitEvaluateModel findByParentCode(String dynamicKey, String parentCode) {
    if (StringUtils.isAnyBlank(dynamicKey, parentCode)) {
      return null;
    }
    return this.visitEvaluateModelService.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "协访评价";
  }

  @Override
  public Class<VisitEvaluateModel> dynamicFormClass() {
    return VisitEvaluateModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {

  }

  @Override
  public int getOrder() {
    return 12;
  }
}
