package com.biz.crm.sfa.business.template.visit.evaluate.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.biz.crm.sfa.business.template.visit.evaluate.local.model.VisitEvaluateModel;
import com.bizunited.nebula.common.util.JsonUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 协访评价表单模板操作策略实现类
 * @author jerry7
 */
@Component
public class DynamicTemplateOperationStrategyForVisitEvaluateModel implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyForVisitEvaluate dynamicFormOperationStrategyForVisitEvaluate;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyForVisitEvaluate.dynamicFormCode();
  }

  @Override
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    VisitEvaluateModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), VisitEvaluateModel.class);
    this.dynamicFormOperationStrategyForVisitEvaluate.onDynamicFormCreate(goodsCollectModel, dynamicKey, parentCode, null);
  }

  @Override
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    VisitEvaluateModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), VisitEvaluateModel.class);
    this.dynamicFormOperationStrategyForVisitEvaluate.onDynamicFormModify(goodsCollectModel, dynamicKey, parentCode, null);
  }

  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyForVisitEvaluate.findByParentCode(dynamicKey, parentCode);
  }
}
