package com.biz.crm.sfa.business.template.visit.evaluate.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 协访评价Dto
 *
 * @author jerry7
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitEvaluateDto", description = "协访评价Dto")
public class VisitEvaluateDto {

  private static final long serialVersionUID = -8528283005139138116L;


  /**
   * 站点名称
   */
  @ApiModelProperty("站点名称")
  private String clientName;

  /**
   * 协访用户姓名
   */
  @ApiModelProperty("协访用户姓名")
  private String helpUserName;

  /**
   * 协访职位名称
   */
  @ApiModelProperty("协访职位名称")
  private String helpPostName;

  /**
   * 被协访用户姓名
   */
  @ApiModelProperty("被协访用户姓名")
  private String coverHelpUserName;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * tenantCode
   */
  @ApiModelProperty("tenantCode")
  private String tenantCode;
}
