package com.biz.crm.sfa.business.travel.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.service.TravelApplyService;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 出差:  TravelApply: 出差申请
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/travel/travelApply")
@Api(tags = "出差:  TravelApply: 出差申请")
public class TravelApplyController {

  @Autowired
  private TravelApplyService travelApplyService;

  /**
   * 移动端-创建出差申请
   *
   * @param dto 参数dto
   * @return 出差申请
   */
  @ApiOperation(value = "移动端-创建出差申请")
  @PostMapping("create")
  public Result<TravelApplyEntity> create(@RequestBody TravelApplyDto dto) {
    try {
      return Result.ok(this.travelApplyService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-修改出差申请
   *
   * @param dto 参数dto
   * @return 出差申请
   */
  @ApiOperation(value = "移动端-修改出差申请")
  @PostMapping("update")
  public Result<TravelApplyEntity> update(@RequestBody TravelApplyDto dto) {
    try {
      return Result.ok(this.travelApplyService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
