package com.biz.crm.sfa.business.travel.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyDetailVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 出差申请明细
 * @author: rentao
 * @date: 2022/7/5 10:25
 */
@Slf4j
@RestController
@RequestMapping("/v1/travel/travelApplyTetail")
@Api(tags = "出差:  TravelApplyVo: 出差申请明细")
public class TravelApplyDetailVoController {

   @Autowired private TravelApplyDetailVoService travelApplyDetailVoService;

  /**
   * 后台-出差申请明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyVo> 出差申请分页信息
   */
  @ApiOperation(value = "后台-出差申请明细分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TravelApplyDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "travelApplyPageDto", value = "分页Dto") TravelApplyPageDto dto) {
    try {
      return Result.ok(this.travelApplyDetailVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
