package com.biz.crm.sfa.business.travel.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 出差申请人员实体类
 *
 * @author ning.zhang
 * @date 2022/5/31
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TravelApplyUserEntity", description = "出差申请人员实体类")
@Entity
@TableName("sfa_travel_apply_user")
@Table(name = "sfa_travel_apply_user", indexes = {
    @Index(name = "sfa_travel_apply_user_index1", columnList = "apply_id"),
    @Index(name = "sfa_travel_apply_user_index2", columnList = "user_name"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_travel_apply_user", comment = "出差申请人员表")
public class TravelApplyUserEntity extends TenantOpEntity {

  private static final long serialVersionUID = 1866318539606476764L;

  /**
   * 申请ID
   */
  @ApiModelProperty("申请ID")
  @Column(name = "apply_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '申请ID'")
  private String applyId;


  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '人员账号'")
  private String userName;

}
