package com.biz.crm.sfa.business.travel.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 出差申请表的mybatis-plus接口类 {@link TravelApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:31
 */
public interface TravelApplyMapper extends BaseMapper<TravelApplyEntity> {

  /**
   * 通过ID集合查询出差申请信息
   *
   * @param ids ID集合
   * @return 出差申请信息
   */
  List<TravelApplyEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 出差申请分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<TravelApplyEntity> 出差申请分页信息
   */
  Page<TravelApplyEntity> findByConditions(Page<TravelApplyEntity> page, @Param("dto") TravelApplyPageDto dto);

  /**
   * 多条件查询出差申请列表
   *
   * @param model 条件model
   * @return 出差申请列表
   */
  List<TravelApplyEntity> findByTravelApplyConditionModel(@Param("model") TravelApplyConditionModel model);



  /**
   * 出差申请明细分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<TravelApplyDetailVo> 出差申请分页信息
   */
  Page<TravelApplyDetailVo> findDetailByConditions(Page<TravelApplyDetailVo> page, @Param("dto") TravelApplyPageDto dto);

}

