package com.biz.crm.sfa.business.travel.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 出差申请多条件model
 *
 * @author ning.zhang
 * @date 2022/6/23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TravelApplyConditionModel", description = "出差申请多条件model")
public class TravelApplyConditionModel {

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号")
  private String userName;

  /**
   * 出差用户账号集合
   */
  @ApiModelProperty(value = "出差用户账号集合")
  private List<String> travelUserNames;

  /**
   * 开始时间
   */
  @ApiModelProperty(value = "开始时间")
  private String beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(value = "结束时间")
  private String endTime;

  /**
   * 排除的流程状态列表
   */
  @ApiModelProperty(value = "排除的流程状态列表")
  private List<String> excludeProcessStatusList;

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;
}
