package com.biz.crm.sfa.business.travel.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.mapper.TravelApplyMapper;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 出差申请表的数据库访问类 {@link TravelApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:32
 */
@Component
public class TravelApplyRepository extends ServiceImpl<TravelApplyMapper, TravelApplyEntity> {

  /**
   * 通过ID集合查询出差申请信息
   *
   * @param ids ID集合
   * @return 出差申请信息
   */
  public List<TravelApplyEntity> findByIds(List<String> ids) {
    return this.baseMapper.findByIds(ids);
  }

  /**
   * 出差申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyEntity> 出差申请分页信息
   */
  public Page<TravelApplyEntity> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
    Page<TravelApplyEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据流程编码获取申请实体
   *
   * @param processNumber 流程编码
   * @param tenantCode    租户编码
   * @return 申请实体
   */
  public TravelApplyEntity findByProcessNumber(String processNumber, String tenantCode) {
    return this.lambdaQuery()
        .eq(TravelApplyEntity::getTenantCode, tenantCode)
        .eq(TravelApplyEntity::getProcessNumber, processNumber)
        .one();
  }

  /**
   * 多条件查询出差申请列表
   *
   * @param model 条件model
   * @return 出差申请列表
   */
  public List<TravelApplyEntity> findByTravelApplyConditionModel(TravelApplyConditionModel model) {
    return this.baseMapper.findByTravelApplyConditionModel(model);
  }


  /**
   * 出差申请明细分页列表
   *
   * @param dto  请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyDetailVo> 出差申请分页信息
   */
  public Page<TravelApplyDetailVo> findDetailByConditions(Pageable pageable,TravelApplyPageDto dto){
    Page<TravelApplyDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findDetailByConditions(page, dto);
  }
}
