package com.biz.crm.sfa.business.travel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyDetailVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyUserVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 出差申请明细表
 * @author: rentao
 * @date: 2022/7/5 10:14
 */
@Service
@Slf4j
public class TravelApplyDetailVoServiceImpl implements TravelApplyDetailVoService {

  @Autowired
  private TravelApplyRepository travelApplyRepository;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired private UserVoService userVoService;

  @Override
  public Page<TravelApplyDetailVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new TravelApplyPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    if(StringUtils.isNotBlank(dto.getUserRealName())){
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getUserRealName());
      dto.setUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    Page<TravelApplyDetailVo> pageResult = travelApplyRepository.findDetailByConditions(pageable, dto);
    List<TravelApplyDetailVo> list = pageResult.getRecords();
    this.perfectUserInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  /**
   * 完善出差申请用户信息
   *
   * @param list 出差申请
   */
  private void perfectUserInfo(List<TravelApplyDetailVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().flatMap(applyVo -> {
      Set<String> userList = Sets.newHashSet();
      userList.add(applyVo.getUserName());
      userList.add(applyVo.getTravelUserName());
      return userList.stream();
    }).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
      vo.setUserRealName(userVo.getFullName());
      UserVo user = userMap.getOrDefault(vo.getTravelUserName(), new UserVo());
      vo.setTravelFullName(user.getFullName());
    });
  }
}
