package com.biz.crm.sfa.business.travel.local.service.observer;

import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Objects;


/**
 * 出差审批回调类
 *
 * @author ning.zhang
 * @date 2022/6/2
 */
@Component
public class TravelApplyCallbackListener implements CallBackListener {

  @Autowired
  private TravelApplyRepository travelApplyRepository;

  @Override
  @Transactional
  public void onCallBack(CallBackDto dto) {
    if (!dto.getFormType().equals(TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE)) {
      return;
    }
    TravelApplyEntity applyEntity = this.travelApplyRepository.findByProcessNumber(dto.getProcessNo(), TenantUtils.getTenantCode());
    if (Objects.isNull(applyEntity)) {
      return;
    }
    //校验审批状态
    Validate.isTrue(applyEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), "此申请非审批中状态，无法进行操作！");
    //根据回调类别处理对应业务
    if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.APPROVED.getCode())) {
      //审批通过业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
      applyEntity.setAuditPassDate(LocalDateTime.now().format(TravelConstant.YYYY_MM_DD_HH_MM_SS));
    } else if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.REJECTED.getCode())) {
      //审批驳回业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.REJECTED.getCode());
    } else if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.INTERRUPT.getCode())) {
      //流程追回业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.INTERRUPT.getCode());
    }
    this.travelApplyRepository.updateById(applyEntity);
  }
}
