/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.travel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyDetailVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TravelApplyDetailVoServiceImpl
implements TravelApplyDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(TravelApplyDetailVoServiceImpl.class);
    @Autowired
    private TravelApplyRepository travelApplyRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private UserVoService userVoService;

    public Page<TravelApplyDetailVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (TravelApplyPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new TravelApplyPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)dto.getUserRealName())) {
            UserConditionDto userConditionDto = new UserConditionDto();
            userConditionDto.setFullName(dto.getUserRealName());
            dto.setUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
        }
        Page<TravelApplyDetailVo> pageResult = this.travelApplyRepository.findDetailByConditions(pageable, dto);
        List list = pageResult.getRecords();
        this.perfectUserInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    private void perfectUserInfo(List<TravelApplyDetailVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set userNames = list.stream().flatMap(applyVo -> {
            HashSet userList = Sets.newHashSet();
            userList.add(applyVo.getUserName());
            userList.add(applyVo.getTravelUserName());
            return userList.stream();
        }).collect(Collectors.toSet());
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList(userNames));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
        list.forEach(vo -> {
            UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
            vo.setUserRealName(userVo.getFullName());
            UserVo user = userMap.getOrDefault(vo.getTravelUserName(), new UserVo());
            vo.setTravelFullName(user.getFullName());
        });
    }
}

