/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.travel.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.local.service.TravelApplyService;
import com.biz.crm.sfa.business.travel.local.service.TravelApplyUserService;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyDto;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyUserDto;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="travelApplyService")
public class TravelApplyServiceImpl
implements TravelApplyService {
    private static final Logger log = LoggerFactory.getLogger(TravelApplyServiceImpl.class);
    @Autowired
    private TravelApplyRepository travelApplyRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TravelApplyUserService travelApplyUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private UserVoService userVoService;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    @Transactional
    public TravelApplyEntity create(TravelApplyDto dto) {
        this.createValidation(dto);
        this.validateApply(dto);
        TravelApplyEntity entity = (TravelApplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TravelApplyEntity.class, HashSet.class, ArrayList.class, new String[]{"recordIds"}));
        entity.setApplyCode((String)this.generateCodeService.generateCode("TA", 1).get(0));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        List userVoList = this.userFeignVoService.findByUserNames(Collections.singletonList(entity.getUserName()));
        if (!CollectionUtils.isEmpty((Collection)userVoList)) {
            Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
            UserVo userVo = userMap.get(dto.getUserName());
            entity.setOrgCode(userVo.getOrgCode());
            entity.setOrgName(userVo.getOrgName());
            entity.setPostCode(userVo.getPositionCode());
            entity.setPostName(userVo.getPositionName());
        }
        this.travelApplyRepository.save((Object)entity);
        dto.setId(entity.getId());
        dto.setApplyCode(entity.getApplyCode());
        this.travelApplyUserService.update(dto);
        entity.setProcessNumber(this.commitProcess(dto));
        this.travelApplyRepository.updateById((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public TravelApplyEntity update(TravelApplyDto dto) {
        TravelApplyEntity entity;
        this.updateValidation(dto);
        this.validateApply(dto);
        TravelApplyEntity applyEntity = (TravelApplyEntity)((Object)this.travelApplyRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)applyEntity), (String)"\u51fa\u5dee\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((ActApproveStatusEnum.REJECTED.getCode().equals(applyEntity.getProcessStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(applyEntity.getProcessStatus()) ? 1 : 0) != 0, (String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91", (Object[])new Object[0]);
        if (ActApproveStatusEnum.REJECTED.getCode().equals(applyEntity.getProcessStatus())) {
            dto.setId(null);
        }
        entity.setApplyCode(StringUtils.isNotBlank((CharSequence)(entity = (TravelApplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TravelApplyEntity.class, HashSet.class, ArrayList.class, new String[]{"recordIds"}))).getId()) ? applyEntity.getApplyCode() : (String)this.generateCodeService.generateCode("TA", 1).get(0));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        List userVoList = this.userFeignVoService.findByUserNames(Collections.singletonList(entity.getUserName()));
        if (!CollectionUtils.isEmpty((Collection)userVoList)) {
            Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
            UserVo userVo = userMap.get(dto.getUserName());
            entity.setOrgCode(userVo.getOrgCode());
            entity.setOrgName(userVo.getOrgName());
            entity.setPostCode(userVo.getPositionCode());
            entity.setPostName(userVo.getPositionName());
        }
        this.travelApplyRepository.saveOrUpdate((Object)entity);
        dto.setId(entity.getId());
        dto.setApplyCode(entity.getApplyCode());
        this.travelApplyUserService.update(dto);
        entity.setProcessNumber(this.commitProcess(dto));
        this.travelApplyRepository.updateById((Object)entity);
        return entity;
    }

    private String commitProcess(TravelApplyDto dto) {
        StartProcessDto startProcessDto = new StartProcessDto();
        startProcessDto.setProcessKey("travel_apply_process001");
        startProcessDto.setBusinessId(dto.getId());
        startProcessDto.setBusinessNo(dto.getApplyCode());
        startProcessDto.setRemark(dto.getProcessRemark());
        startProcessDto.setFormType("travel_apply");
        startProcessDto.setProcessTitle("\u51fa\u5dee\u5ba1\u6279\u6d41\u7a0b");
        startProcessDto.setMenuCode(dto.getCompetenceCode());
        HashMap maps = Maps.newHashMap();
        maps.put("duration", DateUtil.betweenDay((Date)DateUtil.parse((CharSequence)dto.getBeginTime()), (Date)DateUtil.parse((CharSequence)dto.getEndTime()), (boolean)true) + 1L);
        startProcessDto.setVariables((Map)maps);
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)startProcessDto, ProcessListener.class, (SerializableBiConsumer)sf);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId()), (String)"\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01", (Object[])new Object[0]);
        return response.getProcessInstanceId();
    }

    private void createValidation(TravelApplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTravelAddress(), (String)"\u7f3a\u5931\u51fa\u5dee\u5730\u70b9", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTravelObjective(), (String)"\u7f3a\u5931\u51fa\u5dee\u76ee\u7684", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getTravelUserList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u51fa\u5dee\u4eba\u5458", (Object[])new Object[0]);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        dto.setApplyDate(LocalDateTime.now().format(TravelConstant.YYYY_MM_DD_HH_MM_SS));
    }

    private void updateValidation(TravelApplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTravelAddress(), (String)"\u7f3a\u5931\u51fa\u5dee\u5730\u70b9", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTravelObjective(), (String)"\u7f3a\u5931\u51fa\u5dee\u76ee\u7684", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getTravelUserList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u51fa\u5dee\u4eba\u5458", (Object[])new Object[0]);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        dto.setApplyDate(LocalDateTime.now().format(TravelConstant.YYYY_MM_DD_HH_MM_SS));
    }

    private void validateApply(TravelApplyDto dto) {
        TravelApplyConditionModel model = new TravelApplyConditionModel();
        model.setBeginTime(dto.getBeginTime());
        model.setEndTime(dto.getEndTime());
        model.setTenantCode(dto.getTenantCode());
        model.setTravelUserNames(dto.getTravelUserList().stream().map(TravelApplyUserDto::getUserName).collect(Collectors.toList()));
        model.setExcludeProcessStatusList(Lists.newArrayList((Object[])new String[]{ActApproveStatusEnum.REJECTED.getCode(), ActApproveStatusEnum.INTERRUPT.getCode()}));
        List<TravelApplyEntity> applyEntities = this.travelApplyRepository.findByTravelApplyConditionModel(model);
        if (CollectionUtils.isEmpty(applyEntities)) {
            return;
        }
        List existsApplyList = applyEntities.stream().filter(entity -> !entity.getId().equals(dto.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(existsApplyList)) {
            TravelApplyEntity applyEntity = (TravelApplyEntity)((Object)existsApplyList.get(0));
            String existsUserName = applyEntity.getTravelUserList().get(0).getUserName();
            UserVo userVo = (UserVo)ObjectUtils.defaultIfNull((Object)this.userVoService.findByUserName(existsUserName), (Object)new UserVo());
            String beginTime = applyEntity.getBeginTime().compareTo(dto.getBeginTime()) >= 0 ? applyEntity.getBeginTime() : dto.getBeginTime();
            throw new IllegalArgumentException(String.format("\u7528\u6237[%s-%s]\u5df2\u5b58\u5728[%s]\u7684\u51fa\u5dee\u7533\u8bf7\u8bb0\u5f55", existsUserName, userVo.getFullName(), beginTime));
        }
    }
}

