/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.travel.local.service.internal;

import com.biz.crm.sfa.business.travel.local.entity.TravelApplyUserEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyUserRepository;
import com.biz.crm.sfa.business.travel.local.service.TravelApplyUserService;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="travelApplyUserService")
public class TravelApplyUserServiceImpl
implements TravelApplyUserService {
    private static final Logger log = LoggerFactory.getLogger(TravelApplyUserServiceImpl.class);
    @Autowired
    private TravelApplyUserRepository travelApplyUserRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(TravelApplyDto dto) {
        this.updateValidation(dto);
        this.travelApplyUserRepository.deleteByApplyId(dto.getId());
        List entities = dto.getTravelUserList().stream().map(pictureDto -> {
            TravelApplyUserEntity entity = (TravelApplyUserEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, TravelApplyUserEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setApplyId(dto.getId());
            entity.setTenantCode(dto.getTenantCode());
            return entity;
        }).collect(Collectors.toList());
        this.travelApplyUserRepository.saveBatch(entities);
    }

    private void updateValidation(TravelApplyDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u51fa\u5dee\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.getTravelUserList().forEach(pictureDto -> Validate.notBlank((CharSequence)pictureDto.getUserName(), (String)"\u7f3a\u5931\u51fa\u5dee\u4eba\u5458\u8d26\u53f7", (Object[])new Object[0]));
    }
}

