/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.travel.local.service.observer;

import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TravelApplyCallbackListener
implements CallBackListener {
    @Autowired
    private TravelApplyRepository travelApplyRepository;

    @Transactional
    public void onCallBack(CallBackDto dto) {
        if (!dto.getFormType().equals("travel_apply")) {
            return;
        }
        TravelApplyEntity applyEntity = this.travelApplyRepository.findByProcessNumber(dto.getProcessNo(), TenantUtils.getTenantCode());
        if (Objects.isNull((Object)applyEntity)) {
            return;
        }
        Validate.isTrue((boolean)applyEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), (String)"\u6b64\u7533\u8bf7\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessState()), (CharSequence)ActApproveStatusEnum.APPROVED.getCode())) {
            applyEntity.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
            applyEntity.setAuditPassDate(LocalDateTime.now().format(TravelConstant.YYYY_MM_DD_HH_MM_SS));
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessState()), (CharSequence)ActApproveStatusEnum.REJECTED.getCode())) {
            applyEntity.setProcessStatus(ActApproveStatusEnum.REJECTED.getCode());
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessState()), (CharSequence)ActApproveStatusEnum.INTERRUPT.getCode())) {
            applyEntity.setProcessStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        }
        this.travelApplyRepository.updateById((Object)applyEntity);
    }
}

