package com.biz.crm.sfa.business.travel.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 出差:  TravelApplyVo: 出差申请
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/travel/travelApply")
@Api(tags = "出差:  TravelApplyVo: 出差申请")
public class TravelApplyVoController {

  @Autowired
  private TravelApplyVoService travelApplyVoService;

  /**
   * 移动端-出差申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyVo> 出差申请分页信息
   */
  @ApiOperation(value = "移动端-出差申请分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TravelApplyVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "AttendanceFillApplyPageDto", value = "分页Dto") TravelApplyPageDto dto) {
    try {
      return Result.ok(this.travelApplyVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID查询出差申请信息
   *
   * @param id ID
   * @return 出差申请信息
   */
  @ApiOperation(value = "通过ID获取出差申请信息")
  @GetMapping("/findById")
  public Result<TravelApplyVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<TravelApplyVo> list = this.travelApplyVoService.findByIds(Lists.newArrayList(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过流程业务编码获取出差申请信息
   *
   * @param businessNo 流程业务编码
   * @return 出差申请信息
   */
  @ApiOperation(value = "通过流程业务编码获取出差申请信息")
  @GetMapping("/findByBusinessNo")
  public Result<TravelApplyVo> findByBusinessNo(@RequestParam(value = "businessNo", required = false) @ApiParam(name = "businessNo", value = "流程业务编码") String businessNo) {
    try {
      List<TravelApplyVo> list = this.travelApplyVoService.findByApplyCodes(Lists.newArrayList(businessNo));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
