package com.biz.crm.sfa.business.travel.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 出差申请实体类
 *
 * @author ning.zhang
 * @date 2022/5/31
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TravelApplyEntity", description = "出差申请实体类")
@Entity
@TableName("sfa_travel_apply")
@Table(name = "sfa_travel_apply", indexes = {
    @Index(name = "sfa_travel_apply_index1", columnList = "apply_code", unique = true),
    @Index(name = "sfa_travel_apply_index2", columnList = "user_name"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_travel_apply", comment = "出差申请表")
public class TravelApplyEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 6666295426662783105L;

  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  @Column(name = "apply_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '申请编码'")
  private String applyCode;


  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '人员账号'")
  private String userName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:ss)")
  @Column(name = "apply_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '申请日期(yyyy-MM-dd HH:mm:ss)'")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd)")
  @Column(name = "begin_time", length = 20, columnDefinition = "VARCHAR(20) COMMENT '开始时间(yyyy-MM-dd)'")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd)")
  @Column(name = "end_time", length = 20, columnDefinition = "VARCHAR(20) COMMENT '结束时间(yyyy-MM-dd)'")
  private String endTime;

  /**
   * 出差地点
   */
  @ApiModelProperty("出差地点")
  @Column(name = "travel_address", columnDefinition = "VARCHAR(255) COMMENT '出差地点'")
  private String travelAddress;

  /**
   * 出差目的 出差目的
   */
  @ApiModelProperty("出差目的")
  @Column(name = "travel_objective", columnDefinition = "VARCHAR(255) COMMENT '出差目的'")
  private String travelObjective;

  /**
   * 审批通过时间(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("审批通过时间(yyyy-MM-dd HH:mm:ss)")
  @Column(name = "audit_pass_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '审批通过时间(yyyy-MM-dd HH:mm:ss)'")
  private String auditPassDate;

  /**
   * 职位编码 职位编码
   */
  @Column(name = "post_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码 职位编码'")
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称 职位名称
   */
  @Column(name = "post_name", length = 100, columnDefinition = "varchar(100) COMMENT '职位名称 职位名称'")
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 所属组织编码 所属组织编码
   */
  @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT '所属组织编码 所属组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 所属组织名称 所属组织名称
   */
  @Column(name = "org_name", length = 100, columnDefinition = "varchar(100) COMMENT '所属组织名称 所属组织名称'")
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 出差人员
   */
  @ApiModelProperty(value = "出差人员")
  @Transient
  @TableField(exist = false)
  private List<TravelApplyUserEntity> travelUserList;
}
